/* 
 *  IntrinsicsTab.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient;

public class IntrinsicsTab extends KVPTab {

    private static final Logger LOG = Logger.getLogger(IntrinsicsTab.class);

    public IntrinsicsTab(InteractionExecutor interactionExe, InteractionDataGUI gui) {
        super(LOG, interactionExe, gui, "Intrinsic");
    }

    @Override
    void update(InteractionDataI data) {
    	getTab().setDisable(false);
        getList().clear();
        getList().addAll(KVPItem.convertIntrinsicsList(data.getIntrinsics()));
    }

    @Override
    void add(String interactionID, String name, String newValue) {
        interactionExe.editOrAddIntrinsic(gui.getCurrentItemSelection().getId(), name, newValue);
    }

    @Override
    void edit(String interactionID, String name, String newValue) {
        interactionExe.editOrAddIntrinsic(gui.getCurrentItemSelection().getId(), name, newValue);
    }

    @Override
    void remove(String interactionID, String name) {
        interactionExe.removeIntrinsic(gui.getCurrentItemSelection().getId(), name);
    }

}
